using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CSharpTest
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            
            //axMotecDriverCmd1.OpenCom(3, 115200, 8, 0, 1);
            //ʼcb
            cbPort.Items.Add("COM1");
            cbPort.Items.Add("COM2");
            cbPort.Items.Add("COM3");
            cbPort.Items.Add("COM4");
            cbPort.Items.Add("COM5");
            cbPort.Items.Add("COM6");
            cbPort.Items.Add("COM7");
            cbPort.Items.Add("COM8");
            cbPort.Items.Add("COM9");
            cbPort.Items.Add("COM10");
            cbPort.Items.Add("COM11");
            cbPort.SelectedIndex = 2;
            //ʼcb
            cbBaud.Items.Add("9600");
            cbBaud.Items.Add("19200");
            cbBaud.Items.Add("38400");
            cbBaud.Items.Add("115200");
            cbBaud.SelectedIndex = 3;
            //ʼtextbox
            tbPos.Text = "100000";
            tbVel.Text = "500";

            btnConnect.BackColor = Color.Red;

            
        }

        private void axMotecDriverCmd1_Enter(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            axMotecDriverCmd1.MoveRelative(int.Parse(tbPos.Text));
            axMotecDriverCmd1.Go();
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            int nPort, nBaud; bool bResult;
            nPort = cbPort.SelectedIndex + 1;
            nBaud = int.Parse(cbBaud.Text);
            if (btnConnect.Text == "")
            {
                bResult = axMotecDriverCmd1.OpenCom(nPort, nBaud, 8, 0, 0);
                bResult = axMotecDriverCmd1.EchoTesting();
                if (bResult == true)
                {
                    btnConnect.Text = "Ͽ";
                    timer1.Enabled = true;
                    btnConnect.BackColor = Color.Lime;
                }
            }
            else
            {
                axMotecDriverCmd1.CloseCom();
                btnConnect.Text = "";
                btnConnect.BackColor = Color.Red;
                timer1.Enabled = false;
            }
             
            
        }

        private void btnEnable_Click(object sender, EventArgs e)
        {
            axMotecDriverCmd1.PutMotorEnableStatus(1);
        }

        private void btnDisable_Click(object sender, EventArgs e)
        {
            axMotecDriverCmd1.PutMotorEnableStatus(0);
        }

        private void btnMaxVel_Click(object sender, EventArgs e)
        {
            short nVel = short.Parse(tbVel.Text);
            axMotecDriverCmd1.PutSProfileParameter(nVel, 50, 50);
        }

        private void btnMoveAbsolute_Click(object sender, EventArgs e)
        {
            axMotecDriverCmd1.MoveAbsolute(int.Parse(tbPos.Text));
            axMotecDriverCmd1.Go();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            float fVel1=0,fVel2=0;
            axMotecDriverCmd1.GetVelocity(ref fVel1, ref fVel2);
            string b = fVel1.ToString("f1");
            tbVelDisp.Text = b;

            int nPos1=0,nPos2=0;
            axMotecDriverCmd1.GetPosition(ref nPos1, ref nPos2);
            tbPosDisp.Text = nPos1.ToString();

            axMotecDriverCmd1.GetError(ref nPos1);
            tbErr.Text = nPos1.ToString();
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            axMotecDriverCmd1.QuickStop();
        }

        private void btnClearErr_Click(object sender, EventArgs e)
        {
            axMotecDriverCmd1.ClearErrors();
        }

        private void btnReset_Click(object sender, EventArgs e)
        {
            axMotecDriverCmd1.ResetPosition();
        }

       
       
    }
}