// SampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample.h"
#include "SampleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleDlg dialog

CSampleDlg::CSampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSampleDlg)
	m_sAddressNum = _T("");
	m_sSequenceNum = _T("");
	m_sActPos = _T("");
	m_sActSpeed = _T("");
	m_fSetSpeed = 0.0f;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSampleDlg)
	DDX_Control(pDX, IDC_COMBO_CONTROLMODE, m_ctrlControlMode);
	DDX_Control(pDX, IDC_COMBO_OPMODE, m_ctrlOperationMode);
	DDX_Control(pDX, IDC_COM, m_cComboBoxCom);
	DDX_Control(pDX, IDC_BAUD, m_cComboBoxBaud);
	DDX_Text(pDX, IDC_EDIT_ADDRESSNUM, m_sAddressNum);
	DDX_Control(pDX, IDC_MOTECDRIVERCMDCTRL1, m_cMotecDriverCmd);
	DDX_Text(pDX, IDC_ACTPOS, m_sActPos);
	DDX_Text(pDX, IDC_ACTSPEED, m_sActSpeed);
	DDX_Text(pDX, IDC_EDIT_SETSPEED, m_fSetSpeed);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSampleDlg, CDialog)
	//{{AFX_MSG_MAP(CSampleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_LINK, OnLink)
	ON_BN_CLICKED(IDC_SEND, OnSend)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_SERVO, OnButtonServo)
	ON_BN_CLICKED(IDC_BUTTON_UPDATESPEED, OnButtonUpdatespeed)
	ON_BN_CLICKED(IDC_OFFLINE, OnOffline)
	ON_CBN_EDITCHANGE(IDC_COMBO_CONTROLMODE, OnEditchangeComboControlmode)
	ON_BN_CLICKED(IDC_OFFLINE2, OnOffline2)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON_UPDATESPEED2, OnButtonUpdatespeed2)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_WRITE, OnWrite)
	ON_BN_CLICKED(IDC_SAVE2FLASH, OnSave2flash)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleDlg message handlers

BOOL CSampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	SetDlgItemInt(IDC_INDEX,1);
	m_cComboBoxCom.SetCurSel(5);
    m_cComboBoxBaud.SetCurSel(4);
	m_ctrlOperationMode.SetCurSel(0);
    m_ctrlControlMode.SetCurSel(1);
	GetDlgItem(IDC_EDIT_ADDRESSNUM)->SetWindowText("1");
	SetDlgItemText(IDC_EDIT_SETSPEED2,"100");
	m_bServoOn=0;
	GetDlgItem(IDC_BUTTON_SERVO)->SetWindowText("ʹ");
	m_btnServo.SubclassDlgItem(IDC_BUTTON_SERVO,this);
	m_btnLink.SubclassDlgItem(IDC_LINK,this);
    m_btnLink.SetInactiveBgColor(RGB(192,192,192));
	m_btnLink.SetActiveBgColor(RGB(220,220,220));

	m_btnServo.SetInactiveBgColor(RGB(192,192,192));
	m_btnServo.SetActiveBgColor(RGB(220,220,220));

	 
	return TRUE; 
}

void CSampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}



void CSampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}


HCURSOR CSampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSampleDlg::OnLink() 
{
	
	UpdateData();
    int iTemp;CString strTemp; BOOL bOpen=FALSE;
	iTemp = m_cComboBoxBaud.GetCurSel();
	m_cComboBoxBaud.GetLBText(iTemp,strTemp);
	iTemp = m_cComboBoxCom.GetCurSel();
	CString strCaption;
	GetDlgItemText(IDC_LINK,strCaption);
	if (strCaption == "")
	{
		bOpen=m_cMotecDriverCmd.OpenCom(iTemp+1,atoi(strTemp),8,0,0);
		bOpen=m_cMotecDriverCmd.EchoTesting();//ʹô˾䣬ȷУ鷽ʽ
		if(bOpen) 
		{
			m_btnLink.SetInactiveBgColor(RGB(0,220,0));
			m_btnLink.SetActiveBgColor(RGB(0,255,0));
			
			
			SetDlgItemText(IDC_LINK,"Ͽ");
		}
		else
		{
			m_btnLink.SetInactiveBgColor(RGB(192,192,192));
			m_btnLink.SetActiveBgColor(RGB(220,220,220));
			
		}
	}
	else{

		if(m_cMotecDriverCmd.IsOpenCom())
		{
			m_cMotecDriverCmd.CloseCom();
			m_btnLink.SetInactiveBgColor(RGB(192,192,192));
			m_btnLink.SetActiveBgColor(RGB(220,220,220));
    		m_btnLink.RedrawWindow();
			GetDlgItem(IDC_BUTTON_SERVO)->EnableWindow(FALSE);
			SetDlgItemText(IDC_LINK,"");
		}
		KillTimer(1);
	
	}


}

void CSampleDlg::OnSend() 
{
	//ȡеĲ
	int nIndex=GetDlgItemInt(IDC_INDEX);
	short nValue=-1;
	m_cMotecDriverCmd.GetParameter(nIndex,&nValue);
	unsigned short temp=nValue;
	CString str;
	str.Format("%u",temp);
	SetDlgItemText(IDC_VALUE,str);
}
long lSpeed=100; long lPos=1000000;
void CSampleDlg::OnTimer(UINT nIDEvent) 
{
	float frpar1,frpar2;
	long lrpar1,lrpar2;
	CString str;
	switch (nIDEvent)
	{
	case 1:
		//
		m_cMotecDriverCmd.GetVelocity(&frpar1,&frpar2);
		m_sActSpeed.Format("%.1f",frpar1); 
		GetDlgItem(IDC_ACTSPEED)->SetWindowText(m_sActSpeed);
		m_cMotecDriverCmd.GetPosition(&lrpar1,&lrpar2);
		m_sActPos.Format("%d",lrpar1);
		GetDlgItem(IDC_ACTPOS)->SetWindowText(m_sActPos);
		str.Format("%d",lrpar2);
		GetDlgItem(IDC_ACTPOS3)->SetWindowText(str);
		m_cMotecDriverCmd.GetCurrent(&lrpar1,&lrpar2);
		//m_cMotecDriverCmd.GetCurrent()
		str.Format("%d",lrpar2);
		GetDlgItem(IDC_ACTPOS2)->SetWindowText(str);
		
		break;
	case 2:
// 		if (lSpeed >1000) lSpeed =1000;
// 		lSpeed+=50;
// 		lPos+=10000;
// 		
// 		m_cMotecDriverCmd.PutParameter(87,0);//趨87Ų 0:T		1:S	 S ¹켣滮ͣ   T߲
// 		m_cMotecDriverCmd.PutTProfileParameter(lSpeed,50,50,30);	//趨T  ٶ  ٶ  Ӽٶ תٶ
// 		m_cMotecDriverCmd.MoveRelative(lPos);
// 		m_cMotecDriverCmd.Go();
		break;
	}

	CDialog::OnTimer(nIDEvent);
}


void CSampleDlg::OnButtonServo() 
{
	CString strCaption;
	GetDlgItemText(IDC_BUTTON_SERVO,strCaption);
	if (strCaption == "ʹ")
	{
        m_cMotecDriverCmd.PutMotorEnableStatus(1);
	    GetDlgItem(IDC_BUTTON_SERVO)->SetWindowText("ͷ");

		m_btnServo.SetInactiveBgColor(RGB(0,220,0));
		m_btnServo.SetActiveBgColor(RGB(0,255,0));
	}
	else
	{
	    m_cMotecDriverCmd.PutMotorEnableStatus(0);
	    GetDlgItem(IDC_BUTTON_SERVO)->SetWindowText("ʹ");
		m_btnServo.SetInactiveBgColor(RGB(192,192,192));
		m_btnServo.SetActiveBgColor(RGB(220,220,220));
	}
	m_btnServo.RedrawWindow();
    	
}

void CSampleDlg::OnButtonUpdatespeed() 
{
	if(!m_cMotecDriverCmd.EchoTesting()) return;
	UpdateData(true);
	
	m_cMotecDriverCmd.PutVelocitySetpoint(m_fSetSpeed);
}

void CSampleDlg::OnOffline() 
{
	UpdateData();
	m_cMotecDriverCmd.Base(atoi(m_sAddressNum));
	if (m_cMotecDriverCmd.IsOpenCom())
	{
		SetTimer(1,200,NULL);
		SetTimer(2,2000,NULL);
	}
}


void CSampleDlg::OnEditchangeComboControlmode() 
{
// 	UpdateData(true);
// 	m_cMotecDriverCmd.PutOperationMode(m_ctrlOperationMode.GetCurSel());
// 	m_cMotecDriverCmd.PutControlMode(m_ctrlControlMode.GetCurSel());
	
}

void CSampleDlg::OnOffline2() 
{
	if(!m_cMotecDriverCmd.EchoTesting()) return;
	m_cMotecDriverCmd.ResetPosition();
}

void CSampleDlg::OnButton1() 
{
	
	if(!m_cMotecDriverCmd.EchoTesting()) return;
	UpdateData(true);
	m_cMotecDriverCmd.PutOperationMode(m_ctrlOperationMode.GetCurSel());
	m_cMotecDriverCmd.PutControlMode(m_ctrlControlMode.GetCurSel());
}

void CSampleDlg::OnButtonUpdatespeed2() 
{
	if(!m_cMotecDriverCmd.EchoTesting()) return;
	UpdateData(true);
	//m_cMotecDriverCmd.PutParameter(179,300);
	CString str;
	GetDlgItemText(IDC_EDIT_SETSPEED2,str);
	m_cMotecDriverCmd.PutCurrentSetpoint(atoi(str));
	
}

void CSampleDlg::OnButton2() 
{
	if(!m_cMotecDriverCmd.EchoTesting()) return;
	m_cMotecDriverCmd.PutParameter(87,0);//趨87Ų 0:T		1:S	 S ¹켣滮ͣ   T߲
	m_cMotecDriverCmd.PutTProfileParameter(1000,50,50,30);	//趨T  ٶ  ٶ  Ӽٶ תٶ
	m_cMotecDriverCmd.MoveRelative(800000);
	m_cMotecDriverCmd.Go();
}

void CSampleDlg::OnWrite() 
{
	int nIndex=GetDlgItemInt(IDC_INDEX);
	int nValue=GetDlgItemInt(IDC_VALUE);

	m_cMotecDriverCmd.PutParameter(nIndex,nValue);
}

void CSampleDlg::OnSave2flash() 
{
	m_cMotecDriverCmd.SaveParameter();
}
