
// StepDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "StepDemo.h"
#include "StepDemoDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CStepDemoDlg dialog




CStepDemoDlg::CStepDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CStepDemoDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CStepDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MOTECDRIVERCMDCTRL1, m_ocxDriverCmd);
}

BEGIN_MESSAGE_MAP(CStepDemoDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CONNECT, &CStepDemoDlg::OnBnClickedConnect)
	ON_BN_CLICKED(IDC_DISCONNECT, &CStepDemoDlg::OnBnClickedDisconnect)
	ON_BN_CLICKED(IDC_ENABLE, &CStepDemoDlg::OnBnClickedEnable)
	ON_BN_CLICKED(IDC_DISABLE, &CStepDemoDlg::OnBnClickedDisable)
	ON_BN_CLICKED(IDC_READ_OPMODE, &CStepDemoDlg::OnBnClickedReadOpmode)
	ON_BN_CLICKED(IDC_READ_CTRLMODE, &CStepDemoDlg::OnBnClickedReadCtrlmode)
	ON_BN_CLICKED(IDC_SET_OPMODE, &CStepDemoDlg::OnBnClickedSetOpmode)
	ON_BN_CLICKED(IDC_SET_CTRLMODE, &CStepDemoDlg::OnBnClickedSetCtrlmode)
	ON_BN_CLICKED(IDC_MOVE_RELATIVE, &CStepDemoDlg::OnBnClickedMoveRelative)
	ON_BN_CLICKED(IDC_MOVE_ABS, &CStepDemoDlg::OnBnClickedMoveAbs)
	ON_BN_CLICKED(IDC_SET_VEL, &CStepDemoDlg::OnBnClickedSetVel)
	ON_BN_CLICKED(IDC_STOP, &CStepDemoDlg::OnBnClickedStop)
	ON_BN_CLICKED(IDC_QUICK_STOP, &CStepDemoDlg::OnBnClickedQuickStop)
	ON_BN_CLICKED(IDC_REFRESH, &CStepDemoDlg::OnBnClickedRefresh)
	ON_BN_CLICKED(IDC_BRAKE, &CStepDemoDlg::OnBnClickedBrake)
	ON_BN_CLICKED(IDC_CLOSE_AUTOBRAKE, &CStepDemoDlg::OnBnClickedCloseAutobrake)
	ON_BN_CLICKED(IDC_READ_BRAKE_STATUS, &CStepDemoDlg::OnBnClickedReadBrakeStatus)
	ON_BN_CLICKED(IDC_GET_ERRORCODE, &CStepDemoDlg::OnBnClickedGetErrorcode)
	ON_BN_CLICKED(IDC_CLEAR_ERROR, &CStepDemoDlg::OnBnClickedClearError)
	ON_BN_CLICKED(IDC_READ_SERIAL, &CStepDemoDlg::OnBnClickedReadSerial)
	ON_BN_CLICKED(IDC_READ_VERSION, &CStepDemoDlg::OnBnClickedReadVersion)
	ON_BN_CLICKED(IDC_READ_PARAM, &CStepDemoDlg::OnBnClickedReadParam)
	ON_BN_CLICKED(IDC_WRITE_PARAM, &CStepDemoDlg::OnBnClickedWriteParam)
	ON_BN_CLICKED(IDC_SAVE, &CStepDemoDlg::OnBnClickedSave)
	ON_BN_CLICKED(IDC_READ_DIN, &CStepDemoDlg::OnBnClickedReadDin)
	ON_BN_CLICKED(IDC_OUT1_ON, &CStepDemoDlg::OnBnClickedOut1On)
	ON_BN_CLICKED(IDC_OUT1_OFF, &CStepDemoDlg::OnBnClickedOut1Off)
	ON_BN_CLICKED(IDC_OUT2_ON, &CStepDemoDlg::OnBnClickedOut2On)
	ON_BN_CLICKED(IDC_OUT2_OFF, &CStepDemoDlg::OnBnClickedOut2Off)
	ON_BN_CLICKED(IDC_OUT3_ON, &CStepDemoDlg::OnBnClickedOut3On)
	ON_BN_CLICKED(IDC_OUT3_OFF, &CStepDemoDlg::OnBnClickedOut3Off)
	ON_BN_CLICKED(IDC_READ_DOUT, &CStepDemoDlg::OnBnClickedReadDout)
	ON_BN_CLICKED(IDC_READ_ANALOG_IN, &CStepDemoDlg::OnBnClickedReadAnalogIn)
	ON_BN_CLICKED(IDC_HOME, &CStepDemoDlg::OnBnClickedHome)
END_MESSAGE_MAP()


// CStepDemoDlg message handlers

BOOL CStepDemoDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	
	SetIcon(m_hIcon, TRUE);			
	SetIcon(m_hIcon, FALSE);		

	SetDlgItemInt(IDC_DISTANCE,100000);
	SetDlgItemInt(IDC_VEL,500);
	SetDlgItemInt(IDC_VEL_SETPOINT,300);
	SetDlgItemInt(IDC_PORT,7);
	SetDlgItemInt(IDC_BAUDRATE,19200);
	SetDlgItemInt(IDC_PARAM,1);

	return TRUE;  
}

void CStepDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CStepDemoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

HCURSOR CStepDemoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


//
void CStepDemoDlg::OnBnClickedConnect()
{
	int nErr=-1;
	//1.򿪴
	nErr=m_ocxDriverCmd.OpenCom(7,19200,8,0,0);
	if(nErr != 1)
	{
		AfxMessageBox(_T("OpenCom failed"));
		return;
	}
	//2.ͨѶ
	nErr = m_ocxDriverCmd.EchoTesting();
	if(nErr != 1)
	{
		AfxMessageBox(_T("EchoTesting failed"));
		return;
	}
	//3.ͣĬΪ1-ŷǲΪ2
	nErr = m_ocxDriverCmd.SetDriverType(2);

	GetDlgItem(IDC_CONNECT)->EnableWindow(FALSE);
	GetDlgItem(IDC_DISCONNECT)->EnableWindow(TRUE);
	SetDlgItemText(IDC_CONNECT,_T("ӳɹ"));

	//ȡʹ״̬
	short sStatus = 0;
	CString strErr;
	nErr = m_ocxDriverCmd.GetMotorEnableStatus(&sStatus);
	if(nErr != 0)
	{
		strErr.Format(_T("GetMotorEnableStatus failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	if( sStatus == 0)
	{
		GetDlgItem(IDC_ENABLE)->EnableWindow(TRUE);
		GetDlgItem(IDC_DISABLE)->EnableWindow(FALSE);
		SetDlgItemText(IDC_ENABLE,_T("ʹ"));
		SetDlgItemText(IDC_DISABLE,_T("ͷ״̬"));
	}
	else
	{
		GetDlgItem(IDC_ENABLE)->EnableWindow(FALSE);
		GetDlgItem(IDC_DISABLE)->EnableWindow(TRUE);
		SetDlgItemText(IDC_ENABLE,_T("ʹ״̬"));
		SetDlgItemText(IDC_DISABLE,_T("ͷ"));
	}

	//ȡģʽͿģʽ
	OnBnClickedReadCtrlmode();
	OnBnClickedReadOpmode();
		
}

//Ͽ
void CStepDemoDlg::OnBnClickedDisconnect()
{
	m_ocxDriverCmd.CloseCom();

	GetDlgItem(IDC_CONNECT)->EnableWindow(TRUE);
	GetDlgItem(IDC_DISCONNECT)->EnableWindow(FALSE);
	SetDlgItemText(IDC_CONNECT,_T(""));
}

//ʹ
void CStepDemoDlg::OnBnClickedEnable()
{
	int nErr = -1;
	CString strErr=_T("");
	//ʹܵ
	nErr = m_ocxDriverCmd.PutMotorEnableStatus(1);
	if( nErr != 0)
	{
		strErr.Format(_T("PutMotorEnableStatus failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	//ȡʹ״̬
	short sStatus = 0;
	nErr = m_ocxDriverCmd.GetMotorEnableStatus(&sStatus);
	if(nErr != 0)
	{
		strErr.Format(_T("GetMotorEnableStatus failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	if( sStatus == 1)
	{
		GetDlgItem(IDC_ENABLE)->EnableWindow(FALSE);
		GetDlgItem(IDC_DISABLE)->EnableWindow(TRUE);
		SetDlgItemText(IDC_ENABLE,_T("ʹ״̬"));
		SetDlgItemText(IDC_DISABLE,_T("ͷ"));
	}
}

//ͷ
void CStepDemoDlg::OnBnClickedDisable()
{
	int nErr = -1;
	CString strErr=_T("");
	//ͷŵ
	nErr = m_ocxDriverCmd.PutMotorEnableStatus(0);
	if( nErr != 0)
	{
		strErr.Format(_T("PutMotorEnableStatus failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	//ȡʹ״̬
	short sStatus = 0;
	nErr = m_ocxDriverCmd.GetMotorEnableStatus(&sStatus);
	if(nErr != 0)
	{
		strErr.Format(_T("GetMotorEnableStatus failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	if( sStatus == 0)
	{
		GetDlgItem(IDC_ENABLE)->EnableWindow(TRUE);
		GetDlgItem(IDC_DISABLE)->EnableWindow(FALSE);
		SetDlgItemText(IDC_ENABLE,_T("ʹ"));
		SetDlgItemText(IDC_DISABLE,_T("ͷ״̬"));
	}
}

//ȡģʽ
void CStepDemoDlg::OnBnClickedReadOpmode()
{
	int nErr = -1;
	short sOpMode = -1;
	CString strErr=_T("");
	nErr = m_ocxDriverCmd.GetOperationMode(&sOpMode);
	if(nErr != 0)
	{
		strErr.Format(_T("GetOperationMode failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	SetDlgItemInt(IDC_OP_MODE,sOpMode);
}

//ȡģʽ
void CStepDemoDlg::OnBnClickedReadCtrlmode()
{
	int nErr = -1;
	short sControlMode = -1;
	CString strErr=_T("");
	nErr = m_ocxDriverCmd.GetControlMode(&sControlMode);
	if(nErr != 0)
	{
		strErr.Format(_T("GetControlMode failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	SetDlgItemInt(IDC_CTRL_MODE,sControlMode);
}

//òģʽ
void CStepDemoDlg::OnBnClickedSetOpmode()
{
	int nErr = -1;
	CString strErr=_T("");
	int nOpMode=GetDlgItemInt(IDC_OP_MODE);
	nErr = m_ocxDriverCmd.PutOperationMode(nOpMode);
	if(nErr != 0)
	{
		strErr.Format(_T("PutOperationMode failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}

//ÿģʽ
void CStepDemoDlg::OnBnClickedSetCtrlmode()
{
	int nErr = -1;
	CString strErr=_T("");
	int nControlMode=GetDlgItemInt(IDC_CTRL_MODE);
	nErr = m_ocxDriverCmd.PutControlMode(nControlMode);
	if(nErr != 0)
	{
		strErr.Format(_T("PutControlMode failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedMoveRelative()
{
	int nErr = -1;
	CString strErr=_T("");
	int nDis=GetDlgItemInt(IDC_DISTANCE);
	//˶
	nErr=m_ocxDriverCmd.MoveRelative(nDis);
	if(nErr != 0)
	{
		strErr.Format(_T("MoveRelative failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	//GO
	nErr =m_ocxDriverCmd.Go();
	if(nErr != 0)
	{
		strErr.Format(_T("Go failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedMoveAbs()
{
	int nErr = -1;
	CString strErr=_T("");
	int nDis=GetDlgItemInt(IDC_DISTANCE);
	//˶
	nErr=m_ocxDriverCmd.MoveAbsolute(nDis);
	if(nErr != 0)
	{
		strErr.Format(_T("MoveAbsolute failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	//GO
	nErr =m_ocxDriverCmd.Go();
	if(nErr != 0)
	{
		strErr.Format(_T("Go failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}

}

void CStepDemoDlg::OnBnClickedSetVel()
{
	int nErr = -1;
	CString strErr=_T("");
	int nVel=GetDlgItemInt(IDC_VEL);
	nErr = m_ocxDriverCmd.PutTProfileParameter(nVel,10,10,100);
	if(nErr != 0)
	{
		strErr.Format(_T("PutTProfileParameter failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedStop()
{
	int nErr = -1;
	CString strErr=_T("");
	nErr = m_ocxDriverCmd.Stop();
	if(nErr != 0)
	{
		strErr.Format(_T("Stop failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedQuickStop()
{
	int nErr = -1;
	CString strErr=_T("");
	nErr = m_ocxDriverCmd.QuickStop();
	if(nErr != 0)
	{
		strErr.Format(_T("QuickStop failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedRefresh()
{
	int nErr = -1;
	CString strErr=_T("");
	int nVel=GetDlgItemInt(IDC_VEL_SETPOINT);
	nErr=m_ocxDriverCmd.PutVelocitySetpoint(nVel);
	if(nErr != 0)
	{
		strErr.Format(_T("PutVelocitySetpoint failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedBrake()
{
	int nErr = -1;
	CString strErr=_T("");
	nErr = m_ocxDriverCmd.PutBrakeAction(1);
	if(nErr != 0)
	{
		strErr.Format(_T("PutBrakeAction failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedCloseAutobrake()
{
	int nErr = -1;
	CString strErr=_T("");
	nErr = m_ocxDriverCmd.PutBrakeAction(0);
	if(nErr != 0)
	{
		strErr.Format(_T("PutBrakeAction failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedReadBrakeStatus()
{
	int nErr = -1;
	CString strErr=_T("");
	short sStatus = -1;
	nErr = m_ocxDriverCmd.GetBrakeStatus(&sStatus);
	if(nErr != 0)
	{
		strErr.Format(_T("GetBrakeStatus failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	SetDlgItemInt(IDC_BRAKE_STATUS,sStatus);
}


void CStepDemoDlg::OnBnClickedGetErrorcode()
{
	int nErr = -1;
	CString strErr=_T("");
	long lErr =-1;
	nErr = m_ocxDriverCmd.GetError(&lErr);
	if(nErr != 0)
	{
		strErr.Format(_T("GetError failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	SetDlgItemInt(IDC_ERR_CODE,lErr);
}


void CStepDemoDlg::OnBnClickedClearError()
{
	int nErr = -1;
	CString strErr=_T("");
	nErr = m_ocxDriverCmd.ClearErrors();
	if(nErr != 0)
	{
		strErr.Format(_T("ClearErrors failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedReadSerial()
{
	int nErr = -1;
	CString strErr=_T("");
	long lSerialNum = -1;
	nErr = m_ocxDriverCmd.GetSerialNumber(&lSerialNum);
	if(nErr != 0)
	{
		strErr.Format(_T("GetSerialNumber failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	CString strSerial;
	strSerial.Format(_T("%u"),lSerialNum);
	SetDlgItemText(IDC_SERIAL_NUM,strSerial);
}


void CStepDemoDlg::OnBnClickedReadVersion()
{
	int nErr = -1;
	CString strErr=_T("");
	 short sHardVer,sSoftVer;
	nErr = m_ocxDriverCmd.GetVersionInformation(&sHardVer,&sSoftVer);
	if(nErr != 0)
	{
		strErr.Format(_T("GetVersionInformation failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	CString str;
	str.Format(_T("%d"),sHardVer);
	SetDlgItemText(IDC_HARDWARE_VER,str);

	str.Format(_T("%d"),sSoftVer);
	SetDlgItemText(IDC_SOFTWARE_VER,str);
}


void CStepDemoDlg::OnBnClickedReadParam()
{
	int nErr = -1;
	CString strErr=_T("");
	int nParam=GetDlgItemInt(IDC_PARAM);
	short sValue = -1;
	nErr = m_ocxDriverCmd.GetParameter(nParam,&sValue);
	if(nErr != 0)
	{
		strErr.Format(_T("GetParameter failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
	CString str;
	str.Format(_T("%u"),sValue);
	SetDlgItemText(IDC_PARAM_VALUE,str);
}


void CStepDemoDlg::OnBnClickedWriteParam()
{
	int nErr = -1;
	CString strErr=_T("");
	int nParamNum =GetDlgItemInt(IDC_PARAM);
	int nValue=GetDlgItemInt(IDC_PARAM_VALUE);
	nErr = m_ocxDriverCmd.PutParameter(nParamNum,nValue);
	if(nErr != 0)
	{
		strErr.Format(_T("PutParameter failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedSave()
{
	int nErr = -1;
	CString strErr=_T("");
	nErr = m_ocxDriverCmd.SaveParameter();
	if(nErr != 0)
	{
		strErr.Format(_T("SaveParameter failed,ErrCode :%d"),nErr);
		AfxMessageBox(strErr);
		return;
	}
}


void CStepDemoDlg::OnBnClickedReadDin()
{
	//8  1~8
	CString strDin;
	strDin.Empty();
	for(int i=0;i<8;i++)
	{
		short sStatus = -1;
		m_ocxDriverCmd.GetDigitalInput(i+1,&sStatus);
		CString str;
		str.Format(_T("%d  "),sStatus);
		strDin+=str;
	}
	SetDlgItemText(IDC_DIGITAL_IN,strDin);
}


void CStepDemoDlg::OnBnClickedOut1On()
{
	
	m_ocxDriverCmd.PutDigitalOutput(1,1);
}


void CStepDemoDlg::OnBnClickedOut1Off()
{
	m_ocxDriverCmd.PutDigitalOutput(1,0);
}


void CStepDemoDlg::OnBnClickedOut2On()
{
	m_ocxDriverCmd.PutDigitalOutput(2,1);
}


void CStepDemoDlg::OnBnClickedOut2Off()
{
	m_ocxDriverCmd.PutDigitalOutput(2,0);
}


void CStepDemoDlg::OnBnClickedOut3On()
{
	m_ocxDriverCmd.PutDigitalOutput(3,1);
}


void CStepDemoDlg::OnBnClickedOut3Off()
{
	m_ocxDriverCmd.PutDigitalOutput(3,0);
}


void CStepDemoDlg::OnBnClickedReadDout()
{
	CString strDin;
	strDin.Empty();
	for(int i=0;i<3;i++)
	{
		short sStatus = -1;
		m_ocxDriverCmd.GetDigitalOutput(i+1,&sStatus);
		CString str;
		str.Format(_T("%d  "),sStatus);
		strDin+=str;
	}
	SetDlgItemText(IDC_DIGITAL_OUT,strDin);
}


void CStepDemoDlg::OnBnClickedReadAnalogIn()
{
	//ģڵֵ-1000+1000ѹ-10VDC+10VDC
	short s1,s2;
	m_ocxDriverCmd.GetAnalogInput(&s1,&s2);
	CString str;
	str.Format(_T("%d"),s1);
	SetDlgItemText(IDC_ANALOG_IN,str);
}


void CStepDemoDlg::OnBnClickedHome()
{
	m_ocxDriverCmd.Homming();
}
